import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
/**
 * You will need to modify the init() method to include the competitors.
 * @version 1 Mar 2023 - improved behaviour for ties.
 */
public class GreedContest extends Frame implements MouseListener, MouseMotionListener
{
    private Image virtualMem;
    private Graphics g0;
    private Font font;//The font for our messages
    private String message;
    private MiniButton play1GameBtn, play1000GameBtn;
    private ArrayList<PlayerScoreCard> players;
    private boolean gameOver;
    private int round, roundTotal;
    private Die d1;
    public GreedContest()
    {
        super("Greed Game Strategy Contest");
        setSize(900,600);
        players = new ArrayList<PlayerScoreCard>();

        //add your competitors here
        // players.add(new PlayerScoreCard(new Player("Random")));
        players.add(new PlayerScoreCard(new TimidPlayer("Timid")));
        players.add(new PlayerScoreCard(new GreedyPlayer("Greedy")));
        players.add(new PlayerScoreCard(new PlayerCT("Fr Chris")));
        players.add(new PlayerScoreCard(new After5Player("After 5")));

        gameOver=true;
        this.play1GameBtn = new MiniButton ("  Play 1 Game",250, 60, 150,40);
        this.play1000GameBtn = new MiniButton ("  Play 1000 Games",450, 60, 200,40);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        font = new Font("Helvetica", Font.BOLD,  18);  
        roundTotal=0;
        round=0;
        message="Greed Contest";
        this.addWindowListener(new WindowListener() {
                public void windowClosing(WindowEvent e) {System.exit(0);}

                public void windowClosed(WindowEvent e) {}

                public void windowOpened(WindowEvent e) {}

                public void windowIconified(WindowEvent e) {}

                public void windowDeiconified(WindowEvent e) {}

                public void windowActivated(WindowEvent e) {}

                public void windowDeactivated(WindowEvent e) {}
            }); 
    }

    public static void main(String[] args)
    {
        GreedContest app= new GreedContest();
        app.setVisible(true);
    }

    public void paint(Graphics g){
        //make a new buffer in case the applet size changed
        virtualMem = createImage(getWidth(),getHeight());
        g0 = virtualMem.getGraphics();
        g0.setColor(Color.WHITE);
        g0.fillRect(0, 0, this.getWidth(), this.getHeight());
        g0.setColor(Color.BLACK);
        g0.setFont(font);
        g0.drawString(this.message, 20, 550);
        g0.drawString("Games played so far: "+players.get(0).getGameCount(), 320, 50);

        g0.drawString("Round:" , 150, 140);
        for(int i=1;i<=5; i++)
            g0.drawString(""+i, 250+(i-1)*45, 140);
        g0.drawString("Score", 480, 140);
        g0.drawString("  Avg Score", 480+50, 140);
        g0.drawString(" Avg Zaps", 630, 140);
        g0.drawString(" Wins", 720, 140);

        if (gameOver){
            this.play1GameBtn.draw(g0);
            this.play1000GameBtn.draw(g0);
        }
        for(int i=0; i<players.size(); i++)
            players.get(i).draw(g0, 150+i*50);

        g.drawImage(virtualMem,0,0,this);//set new display to Screen
    }

    public void update(Graphics g)
    {
        paint(g); //get rid of flicker with this method
    }

    @Override
    public void mouseClicked(MouseEvent e) {}

    @Override
    public void mousePressed(MouseEvent e) {}

    @Override
    public void mouseReleased(MouseEvent e) {
        int x=e.getX();
        int y=e.getY();
        if (gameOver){

            if (play1GameBtn.contains(x, y)){
                newGame();
            } else if (play1000GameBtn.contains(x, y)){
                for (int i=0; i<1000; i++){
                    newGame();
                }
            }
        }else{//game in progress

        }
        repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {}

    @Override
    public void mouseExited(MouseEvent e) {}

    @Override
    public void mouseDragged(MouseEvent e) {}

    @Override
    public void mouseMoved(MouseEvent e) {}

    public int indexOfBest(int[] a){
        int best=0;
        for(int i=0; i<a.length; i++){
            if (a[i]>a[best])
                best=i;
        }
        return best;
    }

    public void newGame(){
        gameOver=false;
        for (PlayerScoreCard p:players){
            p.initNewGame();
            p.resetColors();
        }
        for (round=1; round <=5; round++)
        {
            newRound();
            //ask players to decide first time
            int activePlayers=0;
            for(PlayerScoreCard p:players)
            {
                if (p.isActive())
                {
                    p.decide(round, roundTotal);
                    if (p.isActive())
                        activePlayers++;
                    else {
                        p.setScore(round, roundTotal);
                    }
                }

            }
            //keep rolling until a 2 or all players are inactive
            while (activePlayers>0) 
            {
                activePlayers=0;
                d1 = new Die(220,50, 50);
                if (d1.getValue()==2)
                {
                    for (PlayerScoreCard p:players)
                        if (p.isActive())
                        {
                            p.setScore(round, 0);
                            p.setActive(false);
                            p.increaseZapCount();
                        }
                } else //new die is not a two
                {
                    roundTotal+=d1.getValue();
                    for(PlayerScoreCard p:players)
                    {
                        if (p.isActive())
                        {
                            p.decide(round, roundTotal);
                            if (p.isActive())
                                activePlayers++;
                            else {
                                p.setScore(round, roundTotal);
                            }
                        }
                    }

                }

            }//end of while loop
            repaint();
        }//end of round loop
        //update game totals
        // Mar 1, 2023: handles ties better
        for (PlayerScoreCard p: players)
            p.recordGame();
        int bestScore=0, mostZaps=0, bestAvg=0, bestWins=0;
        String winner="";
        for (int i = 0; i< players.size(); i++){
            if (players.get(i).getCurrentGameTotal()>bestScore)
            {    
                bestScore=players.get(i).getCurrentGameTotal();
            }
            if (players.get(i).getZaps() > mostZaps)
            {
                mostZaps = players.get(i).getZaps();
            }
            if (players.get(i).getTotal() > bestAvg)
            {
                bestAvg = players.get(i).getTotal();
            }
            if (players.get(i).getWins() > bestWins)
            {
                bestWins = players.get(i).getWins();
            }
        }
        for (PlayerScoreCard p:players)
        {
            if (p.getCurrentGameTotal() == bestScore)
            {
                p.recordWin();
                winner += p.getName() + " ";
            }
            if (p.getZaps() == mostZaps)
            {
                p.setZapsColor(Color.RED);
            }
            if (p.getTotal() == bestAvg)
            {
                p.setAvgColor(Color.ORANGE);
            }
            if (p.getWins() == bestWins)
            {
                p.setWinsColor(Color.CYAN);
            }
        }

    
        //message = winner+" won ";
        //message += 100 * bestWins/players.get(0).getGameCount()+"% of the time";
        repaint();
        gameOver=true;
    }//end of game method

    public void newRound(){
        d1=new Die(220,50, 50);
        while (d1.getValue()==2)
            d1=new Die(220,50, 50);//ignore if first roll is a 2
        roundTotal=d1.getValue();
        for(PlayerScoreCard p:players){
            p.initNewRound();
        }
    }
}